/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplicationFinal;

import productsFinal.*;
import static productsFinal.Product.getNextProductNumber;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class TestPriceList {

    public static void main(String[] args) {
        PriceList demo = createDemoPriceList();
        
        //Testing no access modifier
//        products.Description desc = new products.Description("A Comment for description");
//        System.out.println("Description: "+desc.comments);
        
        //Testing protected access
//        NewClass myNewClass = new NewClass();
//        myNewClass.enterDescription("This the description of a new class.");
//        myNewClass.printProduct();
        
        //This should not work
        //System.out.println("Description: "+getDescription());
        
        //Print out demo to make sure it still works after including DATE_CREATED field
//        demo.printList();
        //Make sure you can't change the DATE_CREATED variable.
//        demo.DATE_CREATED = LocalDate.now();
        
        //Accessing static fields
        //Non static fields require an instance.
//        System.out.println(demo.DATE_CREATED);//Using the instance 'demo' we created earlier
        //Static fields don't.
//        System.out.println(PriceList.COPYRIGHT_NOTICE);
        //You can't use the class name to refer to non static fields
        //System.out.println(PriceList.DATE_CREATED);
        //You can use the instance name to refer to the corresponding class fields
        //but this is misleading - so don't!
        //System.out.println(demo.COPYRIGHT_NOTICE);
        
        //Printing out products
//        for (Product p: demo.getList()){
//            System.out.println(p);
//        }
        
        //Testing the static methods
//        Colour myColour=Product.toColour("Red");
//        System.out.println("Red is: "+myColour);
//        System.out.println("Converted back again is: "+ Product.toName(myColour));
//        Pen myPen = new Pen("Red Pen");
//        myPen.setColour("Red");
//        System.out.println("The colour of my pen is: "+myPen.getColour());

        //Testing the static getters and setters
//        System.out.println("Next product number is: "+Product.getNextProductNumber());
//        Product.resetNextProductNumber();
//        System.out.println("Next product number is: "+Product.getNextProductNumber());

        //Static Import
//        System.out.println("Next product number is: "+getNextProductNumber());
//        Product.resetNextProductNumber();
//        System.out.println("Next product number is: "+getNextProductNumber());

        //Can not create and instance of an abstract class
//        Item myItem = new Item("Some generic Item.");

        //Creating an instance of SundryItem
//        SundryItem opalCard = new SundryItem("Opal transport card.");
//        opalCard.setPrice(20.0);
//        opalCard.enterDescription("Opal card for buses, trains and ferries.");
//        opalCard.printProduct();
         demo.printList();
      
    }

    public static PriceList createDemoPriceList() {
        //Create an instance of pen
        Pen myPen = new Pen("Super Pen");
        myPen.type = "Felt-tip";
        myPen.enterDescription("This new pen is just amazing you need to try it!");
        myPen.setPrice(5.00);

        //Create an instance of Pencil
        Pencil myPencil = new Pencil("Custom Pencil");
        myPencil.enterDescription("This pencil is designed to stay sharp longer, and is comfortable in the hand.");
        myPencil.setPrice(2.00);

        //Create an instance of Notepad
        Notepad myNotepad = new Notepad("Student Special");
        myNotepad.enterDescription("240 leaf A4 lecture pad.");
        myNotepad.setPrice(3.50);

        //Create an instance of Eraser
        Eraser myEraser = new Eraser("New and Improved Eraser");
        myEraser.enterDescription("A long lasting smudgeless eraser for all kinds of pencils.");
        myEraser.setPrice(1.50);

        //Create an instance of PencilCase
        PencilCase myPencilCase = new PencilCase("Basic Pencil Case");
        myPencilCase.enterDescription("A small single zip plastic pencil case with lettering for names.");
        myPencilCase.setPrice(3.00);

        //Create and instance of WritingPack including 2x myPens, myEraser, myPencil and myPencilCase
        WritingPack myWritingPack = new WritingPack("Special Writing Pack");
        myWritingPack.pen1 = myPen;
        myWritingPack.pen2 = myPen;
        myWritingPack.pencil = myPencil;
        myWritingPack.eraser = myEraser;
        myWritingPack.pencilCase = myPencilCase;
        myWritingPack.enterDescription("WritingPack including two super pens, a custom pencil,"
                + " a new and improved eraser and a basic pencil case.");
        myWritingPack.setPrice(15.00);

        //create a price list with all these products in it and print it out
        PriceList demoPriceList = new PriceList();
        demoPriceList.addProduct(myPen);
        demoPriceList.addProduct(myPencil);
        demoPriceList.addProduct(myEraser);
        demoPriceList.addProduct(myPencilCase);
        demoPriceList.addProduct(myNotepad);
        demoPriceList.addProduct(myWritingPack);

        return demoPriceList;
    }
}
